/*
 * Decompiled with CFR 0.152.
 */
package jace.core;

import jace.core.CPU;
import jace.core.Keyboard;
import jace.core.RAM;
import jace.core.Video;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class Computer {
    private static Computer theComputer;
    private RAM memory;
    private CPU cpu;
    private Video video;
    private Keyboard keyboard;
    List<Object> accelorationRequestors = new ArrayList<Object>();
    boolean accelorated = false;

    public Computer() {
        theComputer = this;
        this.keyboard = new Keyboard();
    }

    public RAM getMemory() {
        return this.memory;
    }

    public abstract void notifyVBLStateChanged(boolean var1);

    public void setMemory(RAM memory) {
        this.memory = memory;
    }

    public void waitForNextCycle() {
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public CPU getCpu() {
        return this.cpu;
    }

    public void setCpu(CPU cpu) {
        this.cpu = cpu;
    }

    public void loadRom(String path) throws IOException {
        this.memory.loadRom(path);
    }

    public abstract void coldStart();

    public abstract void warmStart();

    public static Computer getComputer() {
        return theComputer;
    }

    public Keyboard getKeyboard() {
        return this.keyboard;
    }

    public void requestSpeed(Object requester) {
        this.accelorationRequestors.add(requester);
        this.accelorated = true;
    }

    public void cancelSpeedRequest(Object requester) {
        this.accelorationRequestors.remove(requester);
        this.accelorated = !this.accelorationRequestors.isEmpty();
    }

    boolean isAccelorated() {
        return this.accelorated;
    }
}

